<?xml version='1.0' encoding='UTF-8'?>
<Folder
  Browseable="True"
  Group="Explorer"
  Name="All-Sky Surveys"
  Searchable="True"
  Thumbnail="http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=aitoff"
  Type="Sky"
>
  <Folder
    Browseable="True"
    Group="View"
    Name="Highlights"
    Searchable="True"
  >
    <ImageSet
      AltUrl="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wtl00{Q}?g=121&amp;band=wwt_rgb"
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Digitized Sky Survey (Color)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="True"
      TileLevels="12"
      Url="http://cdn.worldwidetelescope.org/wwtweb/dss.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>Copyright DSS Consortium. These data are from the DSS2 survey.</Credits>
      <CreditsUrl>http://gsss.stsci.edu/Acknowledgements/DataCopyrights.htm</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/thumbnails/DSS.png</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="PanSTARRS1 3pi"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="12"
      Url="http://mastimg.stsci.edu/surveys/toast/panstarrs/ps_color/{1}/{3}/{3}_{2}.png"
      WidthFactor="2"
    >
      <Credits>PanSTARRS / STScI / C. Brasseur</Credits>
      <CreditsUrl>https://panstarrs.stsci.edu/</CreditsUrl>
      <ThumbnailUrl>http://data1.wwtassets.org/packages/2020/06_ps1_3pi/thumb.png</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Gaia DR2"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="72"
      Sparse="True"
      StockSet="False"
      TileLevels="8"
      Url="http://data1.wwtassets.org/packages/2020/09_gaia_dr2/{1}/{3}/{3}_{2}.png"
      WidthFactor="2"
    >
      <Credits>Gaia Data Processing and Analysis Consortium (DPAC); A. Moitinho / A. F. Silva / M. Barros / C. Barata, University of Lisbon, Portugal; H. Savietto, Fork Research, Portugal</Credits>
      <CreditsUrl>https://sci.esa.int/web/gaia/-/60196-gaia-s-sky-in-colour-equirectangular-projection</CreditsUrl>
      <ThumbnailUrl>http://data1.wwtassets.org/packages/2020/09_gaia_dr2/thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000000120{Q}?g=131"
      BandPass="HydrogenAlpha"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Hydrogen Alpha Full Sky Map"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},halpha"
      WidthFactor="2"
    >
      <Credits>Image Courtesy Douglas Finkbeiner. The full-sky H-alpha map (6' FWHM resolution) is a composite of the Virginia Tech Spectral line Survey (VTSS) in the north and the Southern H-Alpha Sky Survey Atlas (SHASSA) in the south. The Wisconsin H-Alpha Mapper (WHAM) survey provides a stable zero-point over 3/4 of the sky on a one degree scale. </Credits>
      <CreditsUrl>http://www.astro.princeton.edu/~dfink/halpha/processing.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=halpha</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WISE All Sky (Infrared)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={L},{X},{Y},wise"
      WidthFactor="2"
    >
      <Credits>NASA/JPL-Caltech/UCLA</Credits>
      <CreditsUrl>http://wise.ssl.berkeley.edu/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wise</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="2Mass: Imagery (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="8"
      Url="http://www.worldwidetelescope.org/wwtweb/TwoMassToast.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>This publication makes use of data products from the Two Micron All Sky Survey, which is a joint project of the University of Massachusetts and the Infrared Processing and Analysis Center/California Institute of Technology, funded by the National Aeronautics and Space Administration and the National Science Foundation.</Credits>
      <CreditsUrl>http://www.ipac.caltech.edu/2mass/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=2mass</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000113{Q}?g=131"
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="SFD Dust Map (Infrared)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},dust"
      WidthFactor="2"
    >
      <Credits>Data provided by two NASA satellites, the  Infrared Astronomy Satellite (IRAS) and the Cosmic Background Explorer (COBE). Processing by David J. Schlegel, Douglas P. Finkbeiner and Marc Davis, Princeton University and University of California, Berkeley.</Credits>
      <CreditsUrl>http://astro.berkeley.edu/~marc/dust/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=dust</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck CMB"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},planck"
      WidthFactor="2"
    >
      <Credits>Planck is a European Space Agency mission, with significant participation from NASA. NASAs Planck Project Office is based at JPL. JPL contributed mission-enabling technology for both of Plancks science instruments. European, Canadian and U.S. Planck scientists work together to analyze the Planck data.</Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/planck/index.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=planck</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="NVSS: NRAO VLA Sky Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001023{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>National Radio Astronomy Observatory. The NVSS project includes J. J. Condon, W. D. Cotton, E. W. Greisen, Q. F. Yin, R. A. Perley (NRAO), and J. J. Broderick (VPI). TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope.</Credits>
      <CreditsUrl>http://www.cv.nrao.edu/nvss/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=vlss</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX (Ultraviolet)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://www.worldwidetelescope.org/wwtweb/galexTOAST.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>Space Telescope Science Institute. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope. The Galaxy Explorer instrument allows observations to be made in ultraviolet bands Far UV 1350-1780A and Near UV 1770-2730A. This is the GR2/3 release. </Credits>
      <CreditsUrl>http://galex.stsci.edu/GR2/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexboth</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},RASS3Color_3sb_3bb0.8_3hb_7"
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="RASS: ROSAT All Sky Survey (X-ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001132{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>This is a composite of three RASS3 surveys from the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope. Red is soft band (RASS3sb), Green is broad band (RASS3bb), Blue is hard band (RASS3hb)</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosatcolor</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Fermi LAT 8-year (gamma)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/fermilatyear8/Fermi%20LAT%208-yearL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <Credits>Gamma-ray intensity map (photons cm^-2 s-1 sr^-1, &gt;1 GeV) =&gt;1000 MeV

Credit: NASA and FERMI-LAT Team.</Credits>
      <CreditsUrl>https://www.nasa.gov/content/fermi-gamma-ray-space-telescope</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=fermi_lat_8_year</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Radio"
    Searchable="True"
  >
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/VLssToast.aspx?q={1},{2},{3}"
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="VLSS: VLA Low-frequency Sky Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000132{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>VLSS Cohen, A. S.; Lane, W. M.; Cotton, W. D.; Kassim, N. E.; Lazio, T. J. W.; Perley, R. A.; Condon, J. J.; Erickson, W. C.; Served From NASA Skyview</Credits>
      <CreditsUrl>http://lwa.nrl.navy.mil/VLSS/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=VLA</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="VLA FIRST: Faint Images of the Radio Sky at Twenty-centimeters"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="8"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001022{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>The FIRST project team: R.J. Becker, D.H. Helfand, R.L. White M.D. Gregg. S.A. Laurent-Muehleisen. 1994, University of California.</Credits>
      <CreditsUrl>http://sundog.stsci.edu/top.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=vlafirst</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="NVSS: NRAO VLA Sky Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001023{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>National Radio Astronomy Observatory. The NVSS project includes J. J. Condon, W. D. Cotton, E. W. Greisen, Q. F. Yin, R. A. Perley (NRAO), and J. J. Broderick (VPI). TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope.</Credits>
      <CreditsUrl>http://www.cv.nrao.edu/nvss/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=vlss</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="SUMSS: Sydney University Molonglo Sky Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001030{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>The SUMSS project team and 1997-2000 School of Physics, University of Sydney. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (SUMSS, Min=0.001, Max=10).</Credits>
      <CreditsUrl>http://www.physics.usyd.edu.au/ioa/Main/SUMSS</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=most4sumss</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Westerbork Northern Sky Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="8"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000001031{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>WENSS Team. The WENSS project is a collaboration between the Netherlands Foundation for Research in Astronomy (NFRA/ASTRON) and the Leiden Observatory. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (WENSS, Min=0.001, Max=10), who got it from the WENSS FTP site 1999-03-18. The original data was found using the Westerbork Synthesis Radio Telescope, which is operated by NFRA/ASTRON with support from the Netherlands Foundation for Scientific Research (NWO).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Westerbork%20Northern%20Sky%20Survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wsrt</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Bonn 1420 MHz Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001102{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Max Planck Institute for Radio Astronomy, generated by Patricia Reich and Wolfgang Reich using with the Bonn Stockert 25m telescope. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (1420MHz, Min=3000, Max=35000).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Bonn%201420%20MHz%20Survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=1420mhz</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Radio"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="HI All-Sky Continuum Survey (Radio)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000302{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Max Planck Institute for Radio Astronomy, generated by Glyn Haslam using data taken at Jodrell Bank, Effelsberg and Parkes telescopes. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (408MHz, Min=10, Max=200).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#HI%20All-Sky%20Continuum%20Survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=1420mhz</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="WMAP"
    Searchable="True"
  >
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP ILC 5-Year Cosmic Microwave Background"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_ilc_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_ilc_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP K (Linear) 23 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_23GHz_K_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_23ghz_k_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP K (Non-linear) 23 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_23GHz_K_nonlin"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_23ghz_k_nonlin</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP K (Polarization Map) 50 uK"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_polmap_K_50uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_polmap_k_50uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Ka (Linear) 33 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_33GHz_Ka_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_33ghz_ka_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Ka (Non-linear) 33 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_33GHz_Ka_nonlin"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_33ghz_ka_nonlin</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Ka (Polarization Map) 35 uK"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_polmap_Ka_35uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_polmap_ka_35uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Q (Linear) 41 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_41GHz_Q_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_41ghz_q_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Q (Non-linear) 41 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_41GHz_Q_nonlin"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_41ghz_q_nonlin</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Q (Polarization Map) 35 uK"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_polmap_Q_35uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_polmap_q_35uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP V (Linear) 61 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_61GHz_V_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_61ghz_v_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP V (Non-linear) 61 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_61GHz_V_nonlin"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_61ghz_v_nonlin</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP V (Polarization Map) 35 uK"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_polmap_V_35uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_polmap_v_35uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP W (Linear) 94 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_94GHz_W_200uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_94ghz_w_200uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP W (Non-linear) 94 GHz"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_94GHz_W_nonlin"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_94ghz_w_nonlin</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP W (Polarization Map) 35 uK"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},wmap5yr_polmap_W_35uK"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/map/current/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap5yr_polmap_w_35uk</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/wmap.aspx?q={1},{2},{3}"
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Cosmic Microwave Background"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000112{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP QVW Power (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000213{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP QVW Linear (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000212{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP K Band (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000233{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Ka Band (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000000220{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP Q Band (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000000221{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP V Band (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000222{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WMAP W Band (Microwave)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001033{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Courtesy WMAP Science Team</Credits>
      <CreditsUrl>http://map.gsfc.nasa.gov/m_mm/tm_1.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wmap</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Planck"
    Searchable="True"
  >
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Dust &amp; Gas"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planck4channelL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planck4channel_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Thermal Dust"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planckthermaldustL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <Credits>Planck is a European Space Agency mission, with significant participation from NASA. NASAs Planck Project Office is based at JPL. JPL contributed mission-enabling technology for both of Plancks science instruments. European, Canadian and U.S. Planck scientists work together to analyze the Planck data.</Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/planck/index.html</CreditsUrl>
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planckthermaldust_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Spinning Dust"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planckspinningdustL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planckspinningdust_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Molecular Gas (CO)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planckcoL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planckco_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Ionized Gas (free-free)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planckfreefreeL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planckfreefree_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Synchrotron (non-thermal)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/plancksynchrotronL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/plancksynchrotron_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck Lensing (Mass)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/plnk/planckmassmapL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <ThumbnailUrl>http://wwtfiles.blob.core.windows.net/plnk/planckmassmap_thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Microwave"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Planck CMB"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},planck"
      WidthFactor="2"
    >
      <Credits>Planck is a European Space Agency mission, with significant participation from NASA. NASAs Planck Project Office is based at JPL. JPL contributed mission-enabling technology for both of Plancks science instruments. European, Canadian and U.S. Planck scientists work together to analyze the Planck data.</Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/planck/index.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=planck</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Infrared"
    Searchable="True"
  >
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="2Mass: Imagery (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="8"
      Url="http://www.worldwidetelescope.org/wwtweb/TwoMassToast.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>This publication makes use of data products from the Two Micron All Sky Survey, which is a joint project of the University of Massachusetts and the Infrared Processing and Analysis Center/California Institute of Technology, funded by the National Aeronautics and Space Administration and the National Science Foundation.</Credits>
      <CreditsUrl>http://www.ipac.caltech.edu/2mass/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=2mass</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="WISE All Sky (Infrared)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={L},{X},{Y},wise"
      WidthFactor="2"
    >
      <Credits>NASA/JPL-Caltech/UCLA</Credits>
      <CreditsUrl>http://wise.ssl.berkeley.edu/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=wise</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000113{Q}?g=131"
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="SFD Dust Map (Infrared)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},dust"
      WidthFactor="2"
    >
      <Credits>Data provided by two NASA satellites, the  Infrared Astronomy Satellite (IRAS) and the Cosmic Background Explorer (COBE). Processing by David J. Schlegel, Douglas P. Finkbeiner and Marc Davis, Princeton University and University of California, Berkeley.</Credits>
      <CreditsUrl>http://astro.berkeley.edu/~marc/dust/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=dust</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},IRIScolor_12_60_100_6"
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="IRIS: Improved Reprocessing of IRAS Survey (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001130{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>Original IRAS data: NASA/JPL IPAC, IRIS Reprocessing: Canadian Institute for Theoretical Astrophysics/Institut d'Astrophysique Spatiale. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (Red is IRIS100, Green IRIS60, Blue IRIS12).</Credits>
      <CreditsUrl>http://www.cita.utoronto.ca/~mamd/IRIS/IrisOverview.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=iriscolor</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="2MASS: Catalog (Synthetic, Near Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000312{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Image Jina Suh from 2MASS catalog Copyright Microsoft 2007; This publication makes use of data products from the Two Micron All Sky Survey, which is a joint project of the University of Massachusetts and the Infrared Processing and Analysis Center/California Institute of Technology, funded by the National Aeronautics and Space Administration and the National Science Foundation.</Credits>
      <CreditsUrl>http://www.ipac.caltech.edu/2mass/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=2mass</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="IRIS 12 Microns (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000333{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original IRAS data: NASA/JPL IPAC, IRIS Reprocessing: Canadian Institute for Theoretical Astrophysics/Institut d'Astrophysique Spatiale. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (IRIS12, Min=0.5, Max=1000).</Credits>
      <CreditsUrl>http://www.cita.utoronto.ca/~mamd/IRIS/IrisOverview.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=iris12</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="IRIS 25 Microns (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001000{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original IRAS data: NASA/JPL IPAC, IRIS Reprocessing: Canadian Institute for Theoretical Astrophysics/Institut d'Astrophysique Spatiale. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (IRIS25, Min=1, Max=2000).</Credits>
      <CreditsUrl>http://www.cita.utoronto.ca/~mamd/IRIS/IrisOverview.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=iris25</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="IRIS 60 Microns (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000001001{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original IRAS data: NASA/JPL IPAC, IRIS Reprocessing: Canadian Institute for Theoretical Astrophysics/Institut d'Astrophysique Spatiale. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (IRIS60, Min=1, Max=2000).</Credits>
      <CreditsUrl>http://www.cita.utoronto.ca/~mamd/IRIS/IrisOverview.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=iris60</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="IRIS 100 Microns (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001002{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original IRAS data: NASA/JPL IPAC, IRIS Reprocessing: Canadian Institute for Theoretical Astrophysics/Institut d'Astrophysique Spatiale. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (IRIS100, Min=4, Max=4000).</Credits>
      <CreditsUrl>http://www.cita.utoronto.ca/~mamd/IRIS/IrisOverview.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=iris100</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="SFD 100 Micron (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000332{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Data provided by two NASA satellites, the  Infrared Astronomy Satellite (IRAS) and the Cosmic Background Explorer (COBE). Processing by David J. Schlegel, Douglas P. Finkbeiner and Marc Davis, Princeton University and University of California, Berkeley. TOASTing of images done by NASA's SkyView Virtual Telescope (SFD100m, Min=5, Max=5000).</Credits>
      <CreditsUrl>http://adsabs.harvard.edu/abs/1998ApJ...500..525S</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=sfddust</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="COBE DIRBE (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001003{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>COBE Team. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (COBE, Min=10, Max=5000).</Credits>
      <CreditsUrl>http://lambda.gsfc.nasa.gov/product/cobe/dirbe_overview.cfm</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=cobe</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="COBE DIRBE Annual Average Map (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000001011{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>COBE Team. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (COBEAAM, Min=10, Max=5000).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Cosmic%20Background%20Explorer%20DIRBE%20Annual%20Average%20Map</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=cobe</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="IR"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="COBE DIRBE Zodi-Subtracted Mission Average (Infrared)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001010{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>COBE Team. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (COBEZSMA, Min=10, Max=5000).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Cosmic%20Background%20Explorer%20DIRBE%20Zodi-Subtracted%20Mission%20Average</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=cobe</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Optical"
    Searchable="True"
  >
    <ImageSet
      AltUrl="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wtl00{Q}?g=121&amp;band=wwt_rgb"
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Digitized Sky Survey (Color)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="True"
      TileLevels="12"
      Url="http://cdn.worldwidetelescope.org/wwtweb/dss.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>Copyright DSS Consortium. These data are from the DSS2 survey.</Credits>
      <CreditsUrl>http://gsss.stsci.edu/Acknowledgements/DataCopyrights.htm</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/thumbnails/DSS.png</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="PanSTARRS1 3pi"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="12"
      Url="http://mastimg.stsci.edu/surveys/toast/panstarrs/ps_color/{1}/{3}/{3}_{2}.png"
      WidthFactor="2"
    >
      <Credits>PanSTARRS / STScI / C. Brasseur</Credits>
      <CreditsUrl>https://panstarrs.stsci.edu/</CreditsUrl>
      <ThumbnailUrl>http://data1.wwtassets.org/packages/2020/06_ps1_3pi/thumb.png</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Gaia DR2"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="72"
      Sparse="True"
      StockSet="False"
      TileLevels="8"
      Url="http://data1.wwtassets.org/packages/2020/09_gaia_dr2/{1}/{3}/{3}_{2}.png"
      WidthFactor="2"
    >
      <Credits>Gaia Data Processing and Analysis Consortium (DPAC); A. Moitinho / A. F. Silva / M. Barros / C. Barata, University of Lisbon, Portugal; H. Savietto, Fork Research, Portugal</Credits>
      <CreditsUrl>https://sci.esa.int/web/gaia/-/60196-gaia-s-sky-in-colour-equirectangular-projection</CreditsUrl>
      <ThumbnailUrl>http://data1.wwtassets.org/packages/2020/09_gaia_dr2/thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Deep Star Maps 2020"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="True"
      StockSet="False"
      TileLevels="8"
      Url="http://data1.wwtassets.org/packages/2020/10_dsm2020/{1}/{3}/{3}_{2}.png"
      WidthFactor="2"
    >
      <Credits>Ernie Wright, Laurence Schuler, Ian Jones; NASA/Goddard Space
    Flight Center Scientific Visualization Studio; Gaia team/ESA</Credits>
      <Description>This set of star maps was created by plotting the position,
    brightness, and color of 1.7 billion stars from the Hipparcos-2, Tycho-2,
    and Gaia Data Release 2 star catalogs, with help from the Yale Bright Star
    Catalog, UCAC3, and the XHIP Hipparcos cross-reference.</Description>
      <ThumbnailUrl>http://data1.wwtassets.org/packages/2020/10_dsm2020/thumb.jpg</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000000120{Q}?g=131"
      BandPass="HydrogenAlpha"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Hydrogen Alpha Full Sky Map"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},halpha"
      WidthFactor="2"
    >
      <Credits>Image Courtesy Douglas Finkbeiner. The full-sky H-alpha map (6' FWHM resolution) is a composite of the Virginia Tech Spectral line Survey (VTSS) in the north and the Southern H-Alpha Sky Survey Atlas (SHASSA) in the south. The Wisconsin H-Alpha Mapper (WHAM) survey provides a stable zero-point over 3/4 of the sky on a one degree scale. </Credits>
      <CreditsUrl>http://www.astro.princeton.edu/~dfink/halpha/processing.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=halpha</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="SDSS: Sloan Digital Sky Survey (Optical) [DR7]"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="13"
      Url="http://www.worldwidetelescope.org/wwtweb/sdsstoast.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>Copyright SDSS</Credits>
      <CreditsUrl>http://www.sdss.org/collaboration/credits.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=sloan</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tychooct.aspx?q={1},{2},{3}"
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Tycho (Synthetic, Optical)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000000131{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>NASA/Goddard Space Flight Center Scientific Visualization Studio</Credits>
      <CreditsUrl>http://svs.gsfc.nasa.gov/vis/a000000/a003400/a003442/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=tychobrahe</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},USNOBToast_6"
      BandPass="Visible"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="USNOB: US Naval Observatory B 1.0 (Synthetic, Optical)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001210{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>Monet D.G., Levine S.E., Casian B., et al. Astron. J., 125, 984 (2003). Rendering by Jina Suh (Microsoft).</Credits>
      <CreditsUrl>http://cdsarc.u-strasbg.fr/viz-bin/Cat?I/284</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=usnob</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Ultraviolet"
    Searchable="True"
  >
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX 4 Near-UV"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://www.worldwidetelescope.org/wwtweb/galex4near.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>This is the Near UV band (1770-2730A) of the GALEX GR4 data release archived at MAST/STScI.
TOAST-formatted mosaics were obtained using facilities of NASA's SkyView Virtual Telescope.
</Credits>
      <CreditsUrl>http://galex.stsci.edu/GR4/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexnear</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX 4 Far-UV"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://www.worldwidetelescope.org/wwtweb/galex4far.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>This is the Far UV band(1350-1780A) of the GALEX GR4 data release archived at MAST/STScI.
TOAST-formatted mosaics were obtained using facilities of NASA's SkyView Virtual Telescope.
</Credits>
      <CreditsUrl>http://galex.stsci.edu/GR4/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexfar</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX (Ultraviolet)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://www.worldwidetelescope.org/wwtweb/galexTOAST.aspx?q={1},{2},{3}"
      WidthFactor="2"
    >
      <Credits>Space Telescope Science Institute. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope. The Galaxy Explorer instrument allows observations to be made in ultraviolet bands Far UV 1350-1780A and Near UV 1770-2730A. This is the GR2/3 release. </Credits>
      <CreditsUrl>http://galex.stsci.edu/GR2/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexboth</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX 2 Combined"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000003212{Q}?g=209"
      WidthFactor="2"
    >
      <Credits>Space Telescope Science Institute. The GALEX, Galaxy Explorer, instrument allows imaging and spectroscopic observations to be made in two ultraviolet bands, Far UV 1350-1780A and Near UV 1770-2730A. This is the GR2/3 release, not the most recent GR4 release. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope.</Credits>
      <CreditsUrl>http://galex.stsci.edu/GR2/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexboth</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX 2 Near-UV"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000003210{Q}?g=209"
      WidthFactor="2"
    >
      <Credits>Space Telescope Science Institute. The GALEX, Galaxy Explorer, instrument allows imaging and spectroscopic observations to be made in two ultraviolet bands, Far UV 1350-1780A and Near UV 1770-2730A. This is the GR2/3 release, not the most recent GR4 release. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope.</Credits>
      <CreditsUrl>http://galex.stsci.edu/GR2/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexnear</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GALEX 2 Far-UV"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="10"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000003211{Q}?g=209"
      WidthFactor="2"
    >
      <Credits>Space Telescope Science Institute. The GALEX, Galaxy Explorer, instrument allows imaging and spectroscopic observations to be made in two ultraviolet bands, Far UV 1350-1780A and Near UV 1770-2730A. This is the GR2/3 release, not the most recent GR4 release. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope.</Credits>
      <CreditsUrl>http://galex.stsci.edu/GR2/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=galexfar</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},euveColor_555_405_83_5"
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Extreme Ultraviolet Explorer"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000001131{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>Data from Center for Extreme UV Astronomy, University of California at Berkeley. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope. Red is 555 Angstroms (euve555), Green 405 Angstroms, Red 83 Angstroms.</Credits>
      <CreditsUrl>http://archive.stsci.edu/euve/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=euve_jbis_map</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EUVE 83 : Extreme Ultraviolet Explorer 83 Angstroms"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000003{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>Center for Extreme UV Astronomy, University of California at Berkeley. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (euve83, Min=1, Max=150).</Credits>
      <CreditsUrl>http://archive.stsci.edu/euve/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=euvebw_jbis_map</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EUVE 171 : Extreme Ultraviolet Explorer 171 Angstroms"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001012{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Center for Extreme UV Astronomy, University of California at Berkeley. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (euve171, Min=4, Max=200).</Credits>
      <CreditsUrl>http://archive.stsci.edu/euve/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=euvebw_jbis_map</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EUVE 405 : Extreme Ultraviolet Explorer 405 Angstroms"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001013{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Center for Extreme UV Astronomy, University of California at Berkeley. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (euve405, Min=0.7, Max=70).</Credits>
      <CreditsUrl>http://archive.stsci.edu/euve/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=euvebw_jbis_map</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Ultraviolet"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EUVE 555 : Extreme Ultraviolet Explorer 555 Angstroms"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001020{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Center for Extreme UV Astronomy, University of California at Berkeley. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (euve555, Min=5, Max=500).</Credits>
      <CreditsUrl>http://archive.stsci.edu/euve/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=euvebw_jbis_map</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="X-Ray"
    Searchable="True"
  >
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},RASS3Color_3sb_3bb0.8_3hb_7"
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="RASS: ROSAT All Sky Survey (X-ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001132{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>This is a composite of three RASS3 surveys from the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope. Red is soft band (RASS3sb), Green is broad band (RASS3bb), Blue is hard band (RASS3hb)</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosatcolor</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT Soft Band Count Map (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000000320{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>We have made use of the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (RASS3sb, Min=0.2, Max=50).</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosat</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT Hard Band Count Map (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000313{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>We have made use of the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (RASS3hb, Min=0.2, Max=50).</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosat</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},RASS3bb_0.2_50_7"
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT Broad Band Count Map (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000001133{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>We have made use of the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (RASS3bb, Min=0.2, Max=50).</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosat</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT Soft Band Intensity (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000000322{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>We have made use of the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (RASSSB, Min=0.0002, Max=10).</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosathard</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT Hard Band Intensity (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="7"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000000321{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>We have made use of the ROSAT Data Archive of the Max-Planck-Institut fur extraterrestrische Physik (MPE) at Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (RASSHB, Min=0.0002, Max=10).</Credits>
      <CreditsUrl>http://www.xray.mpe.mpg.de/cgi-bin/rosat/rosat-survey</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosathard</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="ROSAT PSPC summed pointed observations, 2 degree cutoff, intensity (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="8"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000323{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Observational data from NASA Goddard Space Flight Center, mosaicking and TOASTing of images done by NASA's SkyView Virtual Telescope (PSPC2int, Min=0.00002, Max=0.01).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/help/pspc_generation.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=rosatpspc2int</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Swift BAT All-Sky Survey: Significance 14-195 keV (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000000330{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>NASA BAT Team. TOASTing of images done by NASA's SkyView Virtual Telescope (BATSig, Min=1, Max=10).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Swift%20BAT%20All-Sky%20Survey:%20Significance%2014-195%20keV</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=batsig</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="XRay"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Swift BAT All-Sky Survey: Flux 14-195 keV (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000000331{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>NASA BAT Team. TOASTing of images done by NASA's SkyView Virtual Telescope (BATFlux, Min=1e-5, Max=1e-3).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#Swift%20BAT%20All-Sky%20Survey:%20Flux%2014-195%20keV</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=batflux</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GRANAT/SIGMA Significance (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:2}.ortho.tiles.virtualearth.net/tiles/wts0000001032{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original data: High Energy Astrophysics Department, Space Research Institute, Moscow, Russia; CEA, Centre d'Etudes de Saclay Orme des Merisiers, France; Centre d'Etude Spatiale des Rayonnements, Toulouse, France; Federation de Recherche Astroparticule et Cosmologie Universite de Paris, France. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (GRANAT_SIGMA_sig, Min=0.5, Max=50).</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#GRANAT/SIGMA</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=granatsigmasig</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="GRANAT/SIGMA Flux (X-Ray)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000001100{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>Original data: High Energy Astrophysics Department, Space Research Institute, Moscow, Russia; CEA, Centre d'Etudes de Saclay Orme des Merisiers, France; Centre d'Etude Spatiale des Rayonnements, Toulouse, France; Federation de Recherche Astroparticule et Cosmologie Universite de Paris, France. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (GRANAT_SIGMA_flux, Min=1e-5, Max=0.01).
</Credits>
      <CreditsUrl>http://skyview.gsfc.nasa.gov/cgi-bin/survey.pl#GRANAT/SIGMA%20Flux</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=granatsigmaflux</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Gamma"
    Searchable="True"
  >
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Fermi LAT 8-year (gamma)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://wwtfiles.blob.core.windows.net/fermilatyear8/Fermi%20LAT%208-yearL{1}X{2}Y{3}.png"
      WidthFactor="2"
    >
      <Credits>Gamma-ray intensity map (photons cm^-2 s-1 sr^-1, &gt;1 GeV) =&gt;1000 MeV

Credit: NASA and FERMI-LAT Team.</Credits>
      <CreditsUrl>https://www.nasa.gov/content/fermi-gamma-ray-space-telescope</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=fermi_lat_8_year</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      AltUrl="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},glast20080826"
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Fermi Six Months (Gamma)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="4"
      Url="http://r{S:0}.ortho.tiles.virtualearth.net/tiles/wts0000002000{Q}?g=182"
      WidthFactor="2"
    >
      <Credits>NASA and the FERMI-LAT Team. Survey announced 26 AUgust 2008.</Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/GLAST/main/index.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=fermilogo</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Fermi Year Two (Gamma)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="6"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},FermiYearTwo"
      WidthFactor="2"
    >
      <Credits>NASA and the FERMI-LAT Team. </Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/GLAST/main/index.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=FermiYearTwo</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="Fermi Year Three (Gamma)"
      Projection="Toast"
      QuadTreeMap=""
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://www.worldwidetelescope.org/wwtweb/tiles.aspx?q={1},{2},{3},FermiYearThree"
      WidthFactor="2"
    >
      <Credits>NASA and the FERMI-LAT Team. </Credits>
      <CreditsUrl>http://www.nasa.gov/mission_pages/GLAST/main/index.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=FermiYearThree</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="CGRO Compton Telescope: 3 channel data (Gamma)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000001021{Q}?g=138"
      WidthFactor="2"
    >
      <Credits>CompTel Instrument Team. Maps generated by Andrew Strong, Max-Planck Institute for Extraterrestrial Physics, Garching, Germany. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (comptel, Min=0.00005, Max=0.1).</Credits>
      <CreditsUrl>http://wwwgro.unh.edu/comptel/comptel_main.html</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=comptel</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EGRET Soft (Gamma)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:3}.ortho.tiles.virtualearth.net/tiles/wts0000000203{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>EGRET Instrument team, NASA Goddard Space Flight Center. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (EGRETsoft, Min=0.0001, Max=0.002).</Credits>
      <CreditsUrl>http://cossc.gsfc.nasa.gov/docs/cgro/egret/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=egretmap</ThumbnailUrl>
    </ImageSet>
    <ImageSet
      BandPass="Gamma"
      BaseDegreesPerTile="180"
      BaseTileLevel="0"
      BottomsUp="False"
      CenterX="0"
      CenterY="0"
      DataSetType="Sky"
      ElevationModel="False"
      FileType=".png"
      Generic="False"
      Name="EGRET Hard (Gamma)"
      Projection="Toast"
      QuadTreeMap="0123"
      Rotation="0"
      Sparse="False"
      StockSet="False"
      TileLevels="5"
      Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wts0000000231{Q}?g=131"
      WidthFactor="2"
    >
      <Credits>EGRET Instrument team, NASA Goddard Space Flight Center. TOAST-formatted data was obtained from NASA's SkyView Virtual Telescope (EGREThard, Min=0.00002, Max=0.005).</Credits>
      <CreditsUrl>http://cossc.gsfc.nasa.gov/docs/cgro/egret/</CreditsUrl>
      <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=egretmap</ThumbnailUrl>
    </ImageSet>
  </Folder>
  <Folder
    Browseable="True"
    Group="View"
    Name="Big Maps"
    Searchable="True"
  >
    <Place
      Angle="0"
      AngularSize="0"
      Classification="Galactic"
      Constellation="SGR"
      DataSetType="Sky"
      Dec="-28.9"
      Magnitude="0"
      Name="GLIMPSE 360"
      Opacity="100"
      RA="17.75"
      Rotation="0"
      ZoomLevel="200"
    >
      <ForegroundImageSet>
        <ImageSet
          BandPass="IR"
          BaseDegreesPerTile="180"
          BaseTileLevel="0"
          BottomsUp="False"
          CenterX="0"
          CenterY="0"
          DataSetType="Sky"
          ElevationModel="False"
          FileType=".png"
          Generic="False"
          Name="GLIMPSE 360"
          Projection="Toast"
          QuadTreeMap=""
          Rotation="0"
          Sparse="False"
          StockSet="False"
          TileLevels="12"
          Url="http://cdn.worldwidetelescope.org/wwtweb/g360.aspx?q={1},{2},{3}"
          WidthFactor="1"
        >
          <Credits>NASA/JPL-Caltech/Univ. of Wisconsin. The GLIMPSE 360 survey was performed using the Spitzer Space Telescope.</Credits>
          <CreditsUrl>http://www.astro.wisc.edu/sirtf/</CreditsUrl>
          <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=glimpsetn</ThumbnailUrl>
        </ImageSet>
      </ForegroundImageSet>
    </Place>
    <Place
      Angle="0"
      AngularSize="360"
      Classification="Galactic"
      Constellation="SGR"
      DataSetType="Sky"
      Dec="-28.9"
      Magnitude="0"
      Name="GLIMPSE Original"
      Opacity="100"
      RA="17.75"
      Rotation="0"
      ZoomLevel="200"
    >
      <ForegroundImageSet>
        <ImageSet
          BandPass="IR"
          BaseDegreesPerTile="180"
          BaseTileLevel="0"
          BottomsUp="False"
          CenterX="0"
          CenterY="0"
          DataSetType="Sky"
          ElevationModel="False"
          FileType=".png"
          Generic="False"
          Name="GLIMPSE Original"
          Projection="Toast"
          QuadTreeMap=""
          Rotation="0"
          Sparse="False"
          StockSet="False"
          TileLevels="11"
          Url="http://www.worldwidetelescope.org/wwtweb/glimpse.aspx?q={1},{2},{3}"
          WidthFactor="2"
        >
          <Credits>NASA/JPL-Caltech/Univ. of Wisconsin. The GLIMPSE survey was performed using the Spitzer Space Telescope.</Credits>
          <CreditsUrl>http://www.astro.wisc.edu/sirtf/</CreditsUrl>
          <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=glimpsetn</ThumbnailUrl>
        </ImageSet>
      </ForegroundImageSet>
    </Place>
    <Place
      Angle="0"
      AngularSize="360"
      Classification="Galactic"
      Constellation="SGR"
      DataSetType="Sky"
      Dec="-28.9"
      Magnitude="0"
      Name="GLIMPSE/MIPSGAL"
      Opacity="100"
      RA="17.75"
      Rotation="0"
      ZoomLevel="200"
    >
      <ForegroundImageSet>
        <ImageSet
          BandPass="IR"
          BaseDegreesPerTile="180"
          BaseTileLevel="0"
          BottomsUp="False"
          CenterX="0"
          CenterY="0"
          DataSetType="Sky"
          ElevationModel="False"
          FileType=".png"
          Generic="False"
          Name="GLIMPSE/MIPSGAL"
          Projection="Toast"
          QuadTreeMap=""
          Rotation="0"
          Sparse="False"
          StockSet="False"
          TileLevels="11"
          Url="http://www.worldwidetelescope.org/wwtweb/mipsgal.aspx?q={1},{2},{3}"
          WidthFactor="2"
        >
          <Credits>NASA/JPL-Caltech/Univ. of Wisconsin. The GLIMPSE survey was performed using the Spitzer Space Telescope.</Credits>
          <CreditsUrl>http://www.astro.wisc.edu/sirtf/</CreditsUrl>
          <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=glimpsemipsgaltn	</ThumbnailUrl>
        </ImageSet>
      </ForegroundImageSet>
    </Place>
    <Place
      Angle="0"
      AngularSize="360"
      Classification="Stellar"
      Constellation="VIR"
      DataSetType="Sky"
      Dec="13.27"
      Magnitude="0"
      Name="Big Picture"
      Opacity="100"
      RA="12.390277777777778"
      Rotation="0"
      ZoomLevel="35"
    >
      <ForegroundImageSet>
        <ImageSet
          BandPass="Visible"
          BaseDegreesPerTile="180"
          BaseTileLevel="0"
          BottomsUp="False"
          CenterX="0"
          CenterY="0"
          DataSetType="Sky"
          ElevationModel="False"
          FileType=".png"
          Generic="False"
          Name="The Big Picture (Optical)"
          Projection="Equirectangular"
          QuadTreeMap="0123"
          Rotation="0"
          Sparse="False"
          StockSet="False"
          TileLevels="13"
          Url="http://r{S:1}.ortho.tiles.virtualearth.net/tiles/wtl11{Q}?g=155&amp;band=wwt_rgb"
          WidthFactor="2"
        >
          <Credits>George Djorgovski, IPAC/CalTech. This single continuous digital sky image is a cut through the core of the Virgo Cluster of galaxies, derived from the Palomar-Quest digital sky survey. This image contains nearly a million faint galaxies, about half a million stars in our Milky Way and about a thousand distant quasars.</Credits>
          <CreditsUrl>http://bigpicture.caltech.edu/</CreditsUrl>
          <ThumbnailUrl>http://www.worldwidetelescope.org/wwtweb/thumbnail.aspx?name=dss</ThumbnailUrl>
        </ImageSet>
      </ForegroundImageSet>
    </Place>
  </Folder>
  <ImageSet
    BandPass="Visible"
    BaseDegreesPerTile="180"
    BaseTileLevel="0"
    BottomsUp="False"
    CenterX="0"
    CenterY="0"
    DataSetType="Sky"
    ElevationModel="False"
    FileType=".png"
    Generic="False"
    Name="Black Sky Background"
    Projection="Toast"
    QuadTreeMap="0123"
    Rotation="0"
    Sparse="False"
    StockSet="False"
    TileLevels="0"
    Url=""
    WidthFactor="2"
  >
    <Credits>Public Domain</Credits>
    <ThumbnailUrl
    ></ThumbnailUrl>
  </ImageSet>
</Folder>
